package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Prestamo;

import java.util.ArrayList;

public class PrestamoController {

    private final DatabaseHelper databaseHelper;

    private final String NOMBRE_TABLA = "prestamos";

    public PrestamoController(Context contexto) {
        databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                        "id integer primary key autoincrement, " +
                        "cliente_id int, " +
                        "direccion_cliente text, " +
                        "telefono_cliente text, " +
                        "ruta_id int, " +
                        "poblacion_id int, " +
                        "colocadora_id int, " +
                        "aval_id int, " +
                        "grupo_poblacion int, " +
                        "monto_prestado int, " +
                        "pago_semanal int, "  +
                        "fecha_prestamo text, " +
                        "modalidad_semanas int, "  +
                        "numero_tarjeton int, "  +
                        "status int, "  +
                        "created_at text, " +
                        "updated_at text) "
                , NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);
    }

    public void truncate(){
        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                        "id integer primary key autoincrement, " +
                        "cliente_id int, " +
                        "direccion_cliente text, " +
                        "telefono_cliente text, " +
                        "ruta_id int, " +
                        "poblacion_id int, " +
                        "colocadora_id int, " +
                        "aval_id int, " +
                        "grupo_poblacion int, " +
                        "monto_prestado int, " +
                        "pago_semanal int, "  +
                        "fecha_prestamo text, " +
                        "modalidad_semanas int, "  +
                        "numero_tarjeton int, "  +
                        "status int, "  +
                        "created_at text, " +
                        "updated_at text) "
                , NOMBRE_TABLA);

        db.execSQL("DROP TABLE IF EXISTS " + NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);

        Log.d("TRUNCATE",NOMBRE_TABLA);
    }

    public int eliminar(Prestamo prestamo) {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        String[] argumentos = {String.valueOf(prestamo.getNumero_tarjeton())};
        return db.delete(NOMBRE_TABLA, "numero_tarjeton = ?", argumentos);
    }

    public long nueva(Prestamo prestamo) {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("cliente_id", prestamo.getCliente_id());
        valoresParaInsertar.put("aval_id", prestamo.getAval_id());
        valoresParaInsertar.put("grupo_poblacion", prestamo.getGrupo_poblacion());
        valoresParaInsertar.put("monto_prestado", prestamo.getMonto_prestado());
        valoresParaInsertar.put("pago_semanal", prestamo.getPago_semanal());
        valoresParaInsertar.put("fecha_prestamo", prestamo.getFecha_prestamo());
        valoresParaInsertar.put("modalidad_semanas", prestamo.getModalidad_semanas());
        valoresParaInsertar.put("numero_tarjeton", prestamo.getNumero_tarjeton());
        valoresParaInsertar.put("status", prestamo.getStatus());
        valoresParaInsertar.put("created_at", prestamo.getStatus());
        valoresParaInsertar.put("updated_at", prestamo.getStatus());

        return db.insert(NOMBRE_TABLA, null, valoresParaInsertar);
    }

    public ArrayList<Prestamo> obtener() {

        ArrayList<Prestamo> prestamos = new ArrayList<>();
        SQLiteDatabase db = databaseHelper.getReadableDatabase();

        //String query = "SELECT prestamos.id, prestamos.cliente_id,prestamos.direccion_cliente,telefono_cliente,prestamos.ruta_id,prestamos.poblacion_id,prestamos.colocadora_id,prestamos.aval_id,prestamos.grupo_poblacion,prestamos.monto_prestado_intereses,prestamos.pago_semanal,prestamos.fehca_prestamoprestamos.modalidad_semanas,prestamos.numero_tarjeton,prestamos.status,prestamos.created_at,prestamos.updated_at,prestamos.comentario,prestamos.comentario_fecha,avales.nombre_completo FROM prestamos INNER JOIN avales WHERE prestamos.aval_id = avales.id";
        String query = "SELECT prestamos.* FROM prestamos";
        Cursor cursor = db.rawQuery(query, null);

        if (cursor == null) {

            return prestamos;

        }
        if (!cursor.moveToFirst()) return prestamos;

        do {

            String id = cursor.getString(0);
            String cliente_id = cursor.getString(1);
            String direccion_cliente = cursor.getString(2);
            String telefono_cliente = cursor.getString(3);
            String ruta_id = cursor.getString(4);
            String poblacion_id = cursor.getString(5);
            String colocadora_id = cursor.getString(6);
            String aval_id = cursor.getString(7);
            String grupo_poblacion = cursor.getString(8);
            String monto_prestado = cursor.getString(9);
            String pago_semanal = cursor.getString(10);
            String fecha_prestamo = cursor.getString(11);
            String modalidad_semanas = cursor.getString(12);
            String numero_tarjeton = cursor.getString(13);
            String status = cursor.getString(14);
            String created_at = cursor.getString(15);
            String updated_at = cursor.getString(16);

            Prestamo prestamoObtenidoDeBD = new Prestamo(id, cliente_id, direccion_cliente, telefono_cliente, ruta_id, poblacion_id, colocadora_id, aval_id,
                    grupo_poblacion, monto_prestado, pago_semanal, fecha_prestamo, modalidad_semanas, numero_tarjeton, status, created_at, updated_at);

            prestamos.add(prestamoObtenidoDeBD);

        } while (cursor.moveToNext());

        cursor.close();
        return prestamos;
    }

    public String getStatus (String id) {
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        String query = "SELECT status FROM pagos WHERE prestamo_id = ? AND status != 0 ORDER BY id DESC LIMIT 1";
        Cursor cursor = db.rawQuery(query, new String[]{id});

        if (cursor.moveToFirst()) {
            String status = cursor.getString(0);
            cursor.close();
            return status;
        } else {
            cursor.close();
            return null;
        }

    }

}
